{**

 * Copyright since 2007 PrestaShop SA and Contributors

 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA

 *

 * NOTICE OF LICENSE

 *

 * This source file is subject to the Open Software License (OSL 3.0)

 * that is bundled with this package in the file LICENSE.md.

 * It is also available through the world-wide-web at this URL:

 * https://opensource.org/licenses/OSL-3.0

 * If you did not receive a copy of the license and are unable to

 * obtain it through the world-wide-web, please send an email

 * to license@prestashop.com so we can send you a copy immediately.

 *

 * DISCLAIMER

 *

 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer

 * versions in the future. If you wish to customize PrestaShop for your

 * needs please refer to https://devdocs.prestashop.com/ for more information.

 *

 * @author    PrestaShop SA and Contributors <contact@prestashop.com>

 * @copyright Since 2007 PrestaShop SA and Contributors

 * @license   https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)

 *}

<!DOCTYPE html>

<html lang="{$iso}">

<head>

  {$header}

  <link href="{$baseAdminUrl}themes/new-theme/public/light_theme.css" rel="stylesheet" type="text/css">

</head>



<body

  class="lang-{$iso_user}{if $lang_is_rtl} lang-rtl{/if} {$controller_name|escape|strtolower}{if $collapse_menu} page-sidebar-closed{/if}{if !empty($debug_mode)} developer-mode{/if}"

  {if isset($js_router_metadata.base_url)}data-base-url="{$js_router_metadata.base_url}"{/if}

  {if isset($js_router_metadata.token)}data-token="{$js_router_metadata.token}"{/if}

>



<div id="main-div" class="light_display_layout">

    {if $install_dir_exists}

      <div class="alert alert-warning">

        {l|escape s='For security reasons, you must also delete the /install folder.' d='Admin.Login.Notification'}

      </div>

    {else}

      {if isset($modal_module_list)}{$modal_module_list}{/if}



      <div class="-notoolbar">

        {hook h='displayAdminAfterHeader'}



        {if $display_header}

          {include file='components/layout/error_messages.tpl'}

          {include file='components/layout/information_messages.tpl'}

          {include file='components/layout/confirmation_messages.tpl'}

          {include file='components/layout/warning_messages.tpl'}

        {/if}



        {$page}

        {hook h='displayAdminEndContent'}

      </div>

    {/if}

</div>



{if isset($php_errors)}

  {include file="error.tpl"}

{/if}

</body>

</html>

